/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPSESSIONAUTHENTICATE_H
#define QKNXNETIPSESSIONAUTHENTICATE_H

#include <QtKnx/qknxnetipframe.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class QKnxNetIpSessionAuthenticateBuilderPrivate;
class Q_KNX_EXPORT QKnxNetIpSessionAuthenticateProxy final
{
public:
    QKnxNetIpSessionAuthenticateProxy() = delete;
    ~QKnxNetIpSessionAuthenticateProxy() = default;

    QKnxNetIpSessionAuthenticateProxy(const QKnxNetIpFrame &&) = delete;
    explicit QKnxNetIpSessionAuthenticateProxy(const QKnxNetIpFrame &frame);

    bool isValid() const;

    QKnxNetIp::SecureUserId userId() const;
    QKnxByteArray messageAuthenticationCode() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder();
        ~Builder();

        Builder &setUserId(QKnxNetIp::SecureUserId userId);
        Builder &setMessageAuthenticationCode(const QKnxByteArray &data);

        QKnxNetIpFrame create() const;

        Builder(const Builder &other);
        Builder &operator=(const Builder &other);

    private:
        QSharedDataPointer<QKnxNetIpSessionAuthenticateBuilderPrivate> d_ptr;
    };
    static QKnxNetIpSessionAuthenticateProxy::Builder builder();

    class Q_KNX_EXPORT SecureBuilder final
    {
    public:
        SecureBuilder();
        ~SecureBuilder();

        SecureBuilder &setUserId(QKnxNetIp::SecureUserId userId);

        QKnxNetIpFrame create(const QByteArray &sessionPassword,
                              const QKnxByteArray &clientPublicKey,
                              const QKnxByteArray &serverPublicKey) const;

        SecureBuilder(const SecureBuilder &other);
        SecureBuilder &operator=(const SecureBuilder &other);

    private:
        QSharedDataPointer<QKnxNetIpSessionAuthenticateBuilderPrivate> d_ptr;
    };
    static QKnxNetIpSessionAuthenticateProxy::SecureBuilder secureBuilder();

private:
    const QKnxNetIpFrame &m_frame;
};

QT_END_NAMESPACE

#endif
